/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.client.jei;

import ca.teamdman.sfm.client.jei.FallingAnvilDisenchantRecipe;
import ca.teamdman.sfm.client.jei.FallingAnvilExperienceShardRecipe;
import ca.teamdman.sfm.client.jei.FallingAnvilFormRecipe;
import ca.teamdman.sfm.client.jei.FallingAnvilJEICategory;
import ca.teamdman.sfm.client.jei.FallingAnvilRecipe;
import ca.teamdman.sfm.client.jei.PrintingPressJEICategory;
import ca.teamdman.sfm.client.screen.ManagerScreen;
import ca.teamdman.sfm.client.screen.SFMWidgetUtils;
import ca.teamdman.sfm.common.recipe.PrintingPressRecipe;
import ca.teamdman.sfm.common.registry.SFMBlocks;
import ca.teamdman.sfm.common.registry.SFMRecipeTypes;
import ca.teamdman.sfm.common.util.SFMResourceLocation;
import java.util.ArrayList;
import java.util.List;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.gui.handlers.IGuiContainerHandler;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IGuiHandlerRegistration;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.runtime.IJeiRuntime;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import org.jetbrains.annotations.Nullable;

@JeiPlugin
public class SFMJEIPlugin
implements IModPlugin {
    @Nullable
    public static SFMJEIPlugin INSTANCE = null;
    @Nullable
    public IJeiRuntime jeiRuntime = null;

    public SFMJEIPlugin() {
        if (INSTANCE != null) {
            throw new IllegalStateException("Tried to create multiple instances of SFMJEIPlugin");
        }
        INSTANCE = this;
    }

    @Nullable
    public static IJeiRuntime getJeiRuntime() {
        return INSTANCE != null ? SFMJEIPlugin.INSTANCE.jeiRuntime : null;
    }

    public ResourceLocation getPluginUid() {
        return SFMResourceLocation.fromSFMPath("sfm");
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        registration.addRecipeCategories(new IRecipeCategory[]{new PrintingPressJEICategory(registration.getJeiHelpers()), new FallingAnvilJEICategory(registration.getJeiHelpers())});
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        registration.addRecipeCatalyst(new ItemStack((ItemLike)SFMBlocks.PRINTING_PRESS_BLOCK.get()), new RecipeType[]{PrintingPressJEICategory.RECIPE_TYPE});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)Blocks.ANVIL), new RecipeType[]{FallingAnvilJEICategory.RECIPE_TYPE});
    }

    public void registerRecipes(IRecipeRegistration registration) {
        ClientLevel level = Minecraft.getInstance().level;
        assert (level != null);
        RecipeManager recipeManager = level.getRecipeManager();
        List printingPressRecipes = recipeManager.getAllRecipesFor(SFMRecipeTypes.PRINTING_PRESS.get());
        ArrayList<PrintingPressRecipe> jeiPrintingPressRecipes = new ArrayList<PrintingPressRecipe>();
        ArrayList<FallingAnvilRecipe> jeiFallingAnvilRecipes = new ArrayList<FallingAnvilRecipe>();
        for (RecipeHolder r : printingPressRecipes) {
            PrintingPressRecipe printingPressRecipe = (PrintingPressRecipe)r.value();
            jeiPrintingPressRecipes.add(printingPressRecipe);
            jeiFallingAnvilRecipes.add(new FallingAnvilFormRecipe(printingPressRecipe));
        }
        jeiFallingAnvilRecipes.add(new FallingAnvilDisenchantRecipe());
        jeiFallingAnvilRecipes.add(new FallingAnvilExperienceShardRecipe());
        registration.addRecipes(PrintingPressJEICategory.RECIPE_TYPE, jeiPrintingPressRecipes);
        registration.addRecipes(FallingAnvilJEICategory.RECIPE_TYPE, jeiFallingAnvilRecipes);
    }

    public void registerGuiHandlers(IGuiHandlerRegistration registration) {
        registration.addGuiContainerHandler(ManagerScreen.class, (IGuiContainerHandler)new IGuiContainerHandler<ManagerScreen>(this){

            public List<Rect2i> getGuiExtraAreas(ManagerScreen screen) {
                List<Button> buttons = screen.getButtonsForJEIExclusionZones();
                return buttons.stream().filter(b -> b.visible).map(b -> new Rect2i(SFMWidgetUtils.getX((AbstractWidget)b), SFMWidgetUtils.getY((AbstractWidget)b), b.getWidth(), b.getHeight())).toList();
            }
        });
    }

    public void onRuntimeAvailable(IJeiRuntime jeiRuntime) {
        this.jeiRuntime = jeiRuntime;
    }

    public void onRuntimeUnavailable() {
        this.jeiRuntime = null;
    }
}

